--#region
-- ####################################################################################
-- #                                                                                  #
-- #  ██╗███╗   ██╗████████╗███████╗██████╗ ██╗ ██████╗ ██████╗                       #
-- #  ██║████╗  ██║╚══██╔══╝██╔════╝██╔══██╗██║██╔═══██╗██╔══██╗                      #
-- #  ██║██╔██╗ ██║   ██║   █████╗  ██████╔╝██║██║   ██║██████╔╝                      #
-- #  ██║██║╚██╗██║   ██║   ██╔══╝  ██╔══██╗██║██║   ██║██╔══██╗                      #
-- #  ██║██║ ╚████║   ██║   ███████╗██║  ██║██║╚██████╔╝██║  ██║                      #
-- #  ╚═╝╚═╝  ╚═══╝   ╚═╝   ╚══════╝╚═╝  ╚═╝╚═╝ ╚═════╝ ╚═╝  ╚═╝                      #
-- #                                                                                  #
-- #  ███╗   ███╗ ██████╗  ██████╗ ██████╗     ██╗     ██╗ ██████╗ ██╗  ██╗████████╗  #
-- #  ████╗ ████║██╔═══██╗██╔═══██╗██╔══██╗    ██║     ██║██╔════╝ ██║  ██║╚══██╔══╝  #
-- #  ██╔████╔██║██║   ██║██║   ██║██║  ██║    ██║     ██║██║  ███╗███████║   ██║     #
-- #  ██║╚██╔╝██║██║   ██║██║   ██║██║  ██║    ██║     ██║██║   ██║██╔══██║   ██║     #
-- #  ██║ ╚═╝ ██║╚██████╔╝╚██████╔╝██████╔╝    ███████╗██║╚██████╔╝██║  ██║   ██║     #
-- #  ╚═╝     ╚═╝ ╚═════╝  ╚═════╝ ╚═════╝     ╚══════╝╚═╝ ╚═════╝ ╚═╝  ╚═╝   ╚═╝     #
-- #                                                                                  #
-- #  ██████╗ ██╗   ██╗    ██╗   ██╗███████╗████████╗ █████╗ ██╗  ██╗██╗              #
-- #  ██╔══██╗╚██╗ ██╔╝    ██║   ██║██╔════╝╚══██╔══╝██╔══██╗██║  ██║██║              #
-- #  ██████╔╝ ╚████╔╝     ██║   ██║███████╗   ██║   ███████║███████║██║              #
-- #  ██╔══██╗  ╚██╔╝      ██║   ██║╚════██║   ██║   ██╔══██║██╔══██║██║              #
-- #  ██████╔╝   ██║       ╚██████╔╝███████║   ██║   ██║  ██║██║  ██║███████╗         #
-- #  ╚═════╝    ╚═╝        ╚═════╝ ╚══════╝   ╚═╝   ╚═╝  ╚═╝╚═╝  ╚═╝╚══════╝         #
-- #                                                                                  #
-- ####################################################################################
--#endregion

--- Version 1.2, 06/03/2025
--- v1.2:
--- added smoothColorChangeDelay and smoothColorChangeStep to control smooth color changes
--- changed previous color tracking to prevent "snapping" when spamming color change
--- 
--- v1.1:
--- added smooth color changes and a config value to enable them
--- fixed the install instructions (scriptable display incident remedied)
--- removed yee yee ass emissive overwriting, just remove your ext_config emissives
--- 
--- Seems to be stable, but I didn't test it much
--- For my other AC stuff and help: https://t.me/ashadyalleyinchibacity 
--- 
--- This work © 2025 by Ustahl is licensed under CC BY-SA 4.0 
--- To view a copy of this license, visit
--- https://creativecommons.org/licenses/by-sa/4.0/

--- Install instructions:
--- Put the script into the extension folder, then put the section below
--- in your ext_config.ini.
--- 
--- [SCRIPT_...]
--- SCRIPT='interior_mood_lightning.lua'

--- Available colors. 
--- 
--- Use default SDK ones (rgb.color.xxx)
--- or rgb(R, G, B) where R, G and B are numbers in 0 - 1 range.
--- 
--- If you found a color code that has R, G or B in 0 - 255 range
--- just do rgb(R / 255, G / 255, B / 255)
--- 
--- You can change the brightness/multiplier lower in emissiveMult
local COLORS = {
    rgb(0.2, 0.2, 0.9),
    rgb(0.9, 0.1, 0.1),
    rgb(0.2, 0.9, 0.2),
    rgb(0.9, 0.9, 0.9),
    rgb(0.35, 0.05, 0.55),
    rgb(200 / 255, 64 / 255, 0)
}

--- To add more than 1 mesh or extra light to lists add a comma
--- and press Enter after each one (that's just for organization).
--- If you don't need left/right door emissives or extra lights
--- just leave the list empty by removing the placeholder.
---
--- Example:
--- local EMISSIVE_MAIN = {
---     "int_ambient",
--- 	"int_ambient_vents",
--- 	"int_ambient_door_left"
--- }

--- Main emissives that will always change colors
---
--- Mesh names, same as defining emissives in ext_config
local EMISSIVE_MAIN = {
    "int_ambient"
}

-- Emissives on the left door (won't change when it's opened)
local EMISSIVE_LEFT_DOOR = {
    "int_door_lf_ambient"
}

-- Emissives on the right door (won't change when it's opened)
local EMISSIVE_RIGHT_DOOR = {
    "int_door_rf_ambient"
}

--- Extra lights (in the footwell, etc.)
--- 
--- If defined with "[LIGHT_EXTRA_...]" use CSP Debug -> Lights -> Debug lights
--- to see the indexes they get assigned
local LIGHTS = {
    "LIGHT_EXTRA_15",
    "LIGHT_EXTRA_16",
    "LIGHT_EXTRA_17",
    "LIGHT_EXTRA_18"
}

-- Change this to change the default color (this is the index in the table)
local colorIndex = 1

-- Change emissiveMult to make the emissives brighter if needed
-- (same as 4th value in ext_config emissives)
local emissiveMult = 15

-- "true" - color changes smoothly, "false" - color changes instantly
local isSmoothingEnabled = true

-- How often the color updates when smooth color changes are enabled, increases
-- performance impact linearly so don't make it too low.
-- Default: 0.05
local smoothColorChangeDelay = 0.05

-- How "big" each color step is for smooth color changes. 1 = 100% (instant),
-- 0.01 = 1% etc. The smaller the step the longer the color changing process will be.
-- Default: 0.05
local smoothColorChangeStep = 0.05

--#region You probably don't need to touch this
local TOTAL_COLORS = #COLORS
local emissiveColor = rgb(0, 0, 0)
local isLeftDoorOpen = false
local isRightDoorOpen = false
local _interval
local storage = ac.storage({
    savedColor = colorIndex
})

local targetColor = COLORS[colorIndex]:clone():scale(emissiveMult)
local previousColor = COLORS[colorIndex]:clone():scale(emissiveMult)
local _initialized = false
--#endregion

local function applyColor()
    emissiveColor = targetColor

    -- Set main emissive color (everything except doors)
    for _, mesh in pairs(EMISSIVE_MAIN) do
        ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
    end

    -- Set left door emissive color if it's closed
    if not isLeftDoorOpen and #EMISSIVE_LEFT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_LEFT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    -- Set right door emissive color if it's closed
    if not isRightDoorOpen and #EMISSIVE_RIGHT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_RIGHT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    if #LIGHTS > 0 then
        for _, light in pairs(LIGHTS) do
            ac.accessCarLight(light).color = emissiveColor:clone():scale(1 / emissiveMult)
        end
    end
end

local function applyColorSmooth(mix)
    local lerpMix = mix or 0

    emissiveColor = emissiveColor:setLerp(previousColor, targetColor, lerpMix)

    -- Set main emissive color (everything except doors)
    for _, mesh in pairs(EMISSIVE_MAIN) do
        ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
    end

    -- Set left door emissive color if it's closed
    if not isLeftDoorOpen and #EMISSIVE_LEFT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_LEFT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    -- Set right door emissive color if it's closed
    if not isRightDoorOpen and #EMISSIVE_RIGHT_DOOR > 0 then
        for _, mesh in pairs(EMISSIVE_RIGHT_DOOR) do
            ac.findNodes(mesh):findMeshes(mesh):setMaterialProperty('ksEmissive', emissiveColor)
        end
    end

    if #LIGHTS > 0 then
        for _, light in pairs(LIGHTS) do
            ac.accessCarLight(light).color = emissiveColor:clone():scale(1 / emissiveMult)
        end
    end

    if lerpMix < 1 then
        setTimeout(function ()
            applyColorSmooth(math.saturate(lerpMix + smoothColorChangeStep))
        end, smoothColorChangeDelay, 'Recursive color change interval')
    end
end

local function nextColor()
    previousColor = emissiveColor:clone()

    if colorIndex == TOTAL_COLORS then
        colorIndex = 1
    else
        colorIndex = colorIndex + 1
    end

    targetColor = COLORS[colorIndex]:clone():scale(emissiveMult)
    storage.savedColor = colorIndex

    if isSmoothingEnabled then
        applyColorSmooth()
    else
        applyColor()
    end
end

local function updateDoors()
    -- Left door, replace extraC with appropriate extra switch
    if car.extraC then
        isLeftDoorOpen = true
    elseif isLeftDoorOpen then
        isLeftDoorOpen = false
        applyColor()
    end
    -- Right door, replace extraD with appropriate extra switch
    if car.extraD then
        isRightDoorOpen = true
    elseif isRightDoorOpen then
        isRightDoorOpen = false
        applyColor()
    end
end

local function initialize()
    colorIndex = storage.savedColor
    targetColor = COLORS[colorIndex]:clone():scale(emissiveMult)
    previousColor = COLORS[colorIndex]:clone():scale(emissiveMult)
    applyColor()
    _initialized = true
end

function script.update(dt)
    -- To change what Extra scrolls through colors:
    -- extraA = ac.setExtraSwitch(0, false)
    -- extraB = ac.setExtraSwitch(1, false)
    -- extraC = ac.setExtraSwitch(2, false)
    -- and so on

    if not _initialized then
        initialize()
    else
        if car.extraE then                  -- replace with extraB, extraC...
            ac.setExtraSwitch(0, false)     -- replace the number with 1, 2...
            if car.extraE then              -- replace with extraB, extraC...
                nextColor()
            end
        end
        updateDoors()
    end
end